#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>
#define SEVER 1
#define JUG 2

#define AUTO 0
#define AUTOBUS 1
#define KAMION 2

pthread_mutex_t mutex=PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cond=PTHREAD_COND_INITIALIZER;
pthread_mutex_t print_mutex=PTHREAD_MUTEX_INITIALIZER;

typedef struct 
{
    int id;
    int smer;
    int tip;

}Vozilo;
int smer=0;
int auta=0;
int autobus=0;
int kamion=0;

void *vozi(void *arg)
{
    Vozilo v=*(Vozilo*)arg;
    sleep(rand()%4);
    pthread_mutex_lock(&print_mutex);
    printf("Vozilo %d dolazi (%s,%s)\n",v.id,
    v.smer==SEVER ? "SEVER":"JUG",
    v.tip==AUTOBUS ? "AUTOBUS":"KAMION"
    );
    pthread_mutex_unlock(&print_mutex);
    pthread_mutex_lock(&mutex);
    while(
        (smer!=0 && smer!=v.smer) || //suprotan smer
        (v.tip==AUTOBUS && (autobus || kamion)) ||
        (v.tip==KAMION && (auta || autobus || kamion))
        )
        pthread_cond_wait(&cond,&mutex);
    smer=v.smer;
    //ulazak na most
    if(v.tip==AUTO) auta++;
    else if(v.tip==AUTOBUS)autobus=1;
    else kamion=1;

    pthread_mutex_unlock(&mutex);
    pthread_mutex_lock(&print_mutex);
    printf("Vozilo %d prelazi most\n",v.tip);
    sleep(1);
    pthread_mutex_unlock(&print_mutex);


    pthread_mutex_lock(&mutex);

    //izlazak
    if(v.tip==AUTO) auta--;
    else if(v.tip==AUTOBUS)autobus=0;
    else kamion=0;
    if(auta==0 && kamion==0 && autobus==0)
    {
        smer=0;
    }
    pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);
    pthread_mutex_lock(&print_mutex);
    printf("VOzilo %d zavrsilo \n",v.id);
    pthread_mutex_unlock(&print_mutex);
    return NULL;


}
int main()
{
    pthread_t p[15];
    Vozilo v[15];
    srand(time(NULL));
    for(int i=0;i<6;i++)
    {
        v[i].id=i;
        v[i].smer=rand()%2 ? SEVER: JUG;
        v[i].tip=rand()%3;
        pthread_create(&p[i],NULL,vozi,&v[i]);

    }
    
    for(int i=0;i<6;i++)
    {
        pthread_join(p[i],NULL);
    }
    pthread_exit(NULL);
}


